; JAWS 3.2 script file for Netscape Navigator 3.0x and 4.0x 
; Copyright 1998 by Henter-Joyce, Inc.
; By Joseph Dunn and Andres Gonzalez 
; last Modified on May 29 1998 to improve focus rect tracking near bottom of screen.
; also made attribute change announcement off by default
; and track focus rect in ns 4 default.
 
include "netscape.jsm"
include "Netscape.jsh"
include "hjconst.jsh"
include "hjglobal.jsh"

globals
; set to TRUE in the SayNonHighlightedText function whenever new text is written to the page window
; This will signal that the next press of the tab key should go to the first anchor on the page, or that Shift_Tab should go 
; to the last anchor
int nsNewPage,
; speak those annoying status line messages
int nsSpeakStatusLine,
; has Netscape run at least once this JFW session
int nsInitialized ,
; has hyper linked text already been found on the screen
int LinkFound,
int InNSNavigator, ; if in navigator then allow tab and enter to activate links etc
int AnnounceAttributeChanges, ; by J Dunn 15/10/97
; 0 off, 1 attributes, 2 color, 3 both
int PreviousBGColor, ; stores prev char color
int PreviousTXTColor,
int PreviousAttributes, ; stores prev char attribs
string GraphicName,
int NextGraphicFound,
int PriorGraphicFound,
string LastStatusMsg,
; variables specific to NSC 4.04
int version4, ; true if in 4.x or false otherwise
int SuppressEcho, ; set to true when locating link or buttonin 4.x to avoid double speaking.
int LinkSearchMethod, ; 0=use highlight method, 1=use focus rect method
string LastLinkSpoken




int Function GetNetscapeVersion ()
return GetProgramVersion (GetAppFilePath())
EndFunction

Function AutoStartEvent ()
if not (nsInitialized) then
; this is the first time we're running Netscape
; set up default variable settings
	let nsSpeakStatusLine = FALSE
	let nsInitialized = 1
 SayExtendedHelpHotKey ()
	Say(msg1, ot_help) ;"Press insert + h for jaws hot keys"
let AnnounceAttributeChanges=0 ; no announcement by default
let LinkSearchMethod=1 ; focus rect tracking in NS 4.0x
let GraphicName=""
EndIf
if GetNetscapeVersion()==4 then
  let Version4=true
else
  let version4=false
EndIf
EndFunction

Void Function  SayNonHighlightedText(handle hwnd, string buffer)
var
	string TheClass

if InNavigator() then
Let InNSNavigator =1 
else
let InNSNavigator=0
endif

let TheClass = GetWindowClass(hwnd)
;wc5="#32771"
if (theClass==wc_page) || (TheClass == wc5) then
	let nsNewPage = TRUE
let NextGraphicFound=false
let PriorGraphicFound=false
	let LinkFound = FALSE
if inNSNavigator && (not suppressEcho) then
	Say(buffer, ot_buffer)
endif
EndIf
If TheClass == wc_statusbar then
let LastStatusMsg=buffer
 if nsSpeakStatusLine then
	If (GetVerbosity () == beginner) then
		Say(msg7, ot_string) ;"Status Line"
	EndIf
	Say(buffer, ot_buffer)
endIf
EndIf
EndFunction

Script  ScriptFileName()
ScriptAndAppNames ("Netscape Navigator")
EndScript


string Function url ()
var
string tmp
if stringContains(lastStatusMsg,"//") then
  let tmp=msg119+lastStatusMsg
elif stringContains(lastStatusMsg,"mailto")then
  let tmp=LastStatusMsg
else
  let tmp=""
EndIf
return tmp
EndFunction

Function SayNextLink3 ()
if (nsNewPage) then
; speak the first anchor on this screen
	let nsNewPage = FALSE
	if MoveToLink (first_link) then
		SayField()
		let LinkFound = true
let LastLinkSpoken=getField()
		RestoreCursor ()
		return
	EndIf
else
	if MoveToLink (next_link) then
		SayField()
let LastLinkSpoken=getField()
		let LinkFound = true
		return
	EndIf
EndIf
PcCursor()
If (GetVerbosity () == BEGINNER) then
	If (LinkFound == TRUE) then
		Say(msg15, ot_message) ;"No more hyper links found on this screen"
	Else
		Say(msg16, ot_message) ;"No hyper links found on this screen"
	EndIf ; LinkFound == TRUE
else
	beep()
EndIf ; verbosity = beginner 
EndFunction

Function sayNextLink4 ()
let suppressEcho=true
{tab}
pause()
if hasFocusRect(GetFocus()) then
  if !SayFocusRects(GetFocus()) then 
    Say(url(), OT_STRING)
  EndIf
else
{tab}
pause()
{shift+tab}
pause()
  if !SayFocusRects(GetFocus()) then
    Say(url(), ot_string)
  endIf
EndIf
let SuppressEcho=false
EndFunction

Function SayPriorLink3 ()
if (nsNewPage) then
; find the last anchor on this page
	let nsNewPage = FALSE
	if MoveToLink (last_link) then
		SayField()
let LastLinkSpoken=getField()
		let LinkFound = true
		return
	EndIf
else
	if MoveToLink (prior_link) then
		SayField()
let LastLinkSpoken=getField()
		let LinkFound = true
		return
	EndIf
EndIf
PcCursor()
If (GetVerbosity () == BEGINNER) then
	If (LinkFound == TRUE) then
		Say(msg15, ot_message) ;"No more hyper links found on this screen"
	Else
		Say(msg16, ot_message) ;"No hyper links found on this screen"
	EndIf ; LinkFound = TRUE
else
	beep()
EndIf ; verbosity = beginner 
EndFunction

Function SayPriorLink4 ()
let suppressEcho=true
{shift+tab}
pause()
if HasFocusRect(GetFocus()) then
  if !SayFocusRects(GetFocus()) then
    Say(url(), ot_string)
  EndIf
else
  {shift+tab}
  pause()
  {tab}
  pause()
  if !SayFocusRects(GetFocus()) then
    Say(url(), ot_string)
  EndIf
EndIf
let suppressEcho=false
EndFunction

Script SayNextLink ()
if ((GetWindowClass (GetFocus ()) != wc_page) ||
    MenusActive() ||
    DialogActive()) ||
(not InNSNavigator) then
say(msg32, ot_message) ; tab
    {tab}
    return
EndIf
if version4 && linkSearchMethod then
  SayNextLink4()
else
  SayNextLink3()
EndIf 
EndScript

Script SayPriorLink()
if ((GetWindowClass (GetFocus ()) != wc_page) || 
	MenusActive() ||
	DialogActive()) ||
(not inNSNavigator) then
Say(msg33, ot_string) ; shift plus tab
	{Shift+tab}
	return
EndIf
if version4 && linkSearchMethod then
  SayPriorLink4()
else
  SayPriorLink3()
EndIf
EndScript


Function repeatLink3 ()
Say(LastLinkSpoken, ot_string)
EndFunction


Function repeatLink4 ()
if HasFocusRect(GetFocus()) then
  if !SayFocusRects(GetFocus()) then
    Say(url(), ot_string)
  endIf
else
  Say(url(), ot_string)
EndIf
EndFunction


Script SayCurrentLink ()
if inNsNavigator then
  if version4 && linkSearchMethod then
    RepeatLink4()
  else
    RepeatLink3()
  EndIf    
endIf
EndScript

Script SayFirstLink()
; Test for cursor.  Allows you to jump to the first link on screen.
if ((GetWindowClass (GetFocus ()) != wc_page) || 
	MenusActive() ||
	DialogActive()) ||
  (not inNSNavigator) then
say(msg29, ot_message) ; home
	JAWSHome ()
	return
EndIf
if not (IsPCCursor ()) then
	JAWSHome ()
	return
EndIf  
let nsNewPage = false
if MoveToLink (first_link) then
	SayField()
	let LinkFound = true
	return
EndIf
PcCursor()
If (GetVerbosity () == BEGINNER) then
	Say(msg16, ot_message) ;"No hyper links found on this screen"
else
	beep()
EndIf ; verbosity = beginner 
EndScript

Script SayLastLink ()
; Test for cursor and allows you to jump to the last link on screen.
if ((GetWindowClass (GetFocus ()) != wc_page) || 
	MenusActive() ||
	DialogActive()) ||
(not InNSNavigator) then
Say(msg30, ot_string) ; end
	JAWSEnd ()
	return
EndIf
if not (IsPCCursor ()) then
	JAWSEnd ()
	return
EndIf  
let nsNewPage = false
if MoveToLink (last_link) then
	SayField()
	let LinkFound = true
	return
EndIf
PcCursor()
If (GetVerbosity () == BEGINNER) then
	Say(msg16, ot_MESSAGE) ;"No hyper links found on this screen"
else
	beep()
EndIf ; verbosity = beginner 
EndScript

Int Function MoveToLink (int direction)
var
	int LinkFound
if not IsJawsCursor() then
	JawsCursor()
EndIf
if (direction == first_link) then
	MoveToControl (GetAppMainWindow (GetFocus ()), cid_page)
	let LinkFound = FindNextAttribute (ATTRIB_UNDERLINE) 
EndIf
if (direction == next_link) then
	if (GetWindowClass (GetCurrentWindow ()) != wc_page) then
		MoveToControl (GetAppMainWindow (GetFocus ()), cid_page)
	EndIf
	let LinkFound = FindNextAttribute (ATTRIB_UNDERLINE) 
EndIf
if (direction == prior_link) then
	if (GetWindowClass (GetCurrentWindow ()) != wc_page) then
		JawsPageDown ()
	EndIf
	let LinkFound = FindPriorAttribute (ATTRIB_UNDERLINE) * (GetWindowClass (GetCurrentWindow ()) == wc_page)
	if not LinkFound then
		MoveToControl (GetAppMainWindow (GetFocus ()), cid_page)
	EndIf
EndIf
if (direction == Last_link) then
	JawsPageDown ()
	let LinkFound = FindPriorAttribute (ATTRIB_UNDERLINE) * (GetWindowClass (GetCurrentWindow ()) == wc_page)
	if not LinkFound then
		MoveToControl (GetAppMainWindow (GetFocus ()), cid_page)
	EndIf
EndIf
;wn14="["
if (GetCharacter() == wn14) then 
	NextCharacter ()
EndIf
return LinkFound 
EndFunction

Script  Enter()
; tests location, performs left mouse click on linked text
if (MenusActive() ||    
	DialogActive() ||
	((GetWindowClass (GetFocus()) != wc_page) &&
	(GetWindowClass (GetParent (GetFocus ())) != wc_page))) ||
  (version4 && LinkSearchMethod) then
let LastStatusMsg=msg111
	{Enter}
	return
EndIf
;wc19="Edit"
If (GetWindowClass (GetFocus ()) == wc19) then
	{Enter}
	Return
EndIf
if (not inNSNavigator) then
Say(msg31, OT_STRING) ; enter 
{enter}
return
endif
if not IsJawsCursor() then
	JawsCursor()
EndIf
LeftMouseButton()
PcCursor()
EndScript

Script  MoveToNextControl()
; moves forward to find edit fields and other controls on forms.
var
	handle WinHandle,
	string TheClass,
	int TheType,
	int nsOnFormField
Let WinHandle = GetFocus ()
let TheClass = GetWindowClass (WinHandle) 
;wc19="edit"
If ((TheClass == wc19) ||
;wc20="button"
(TheClass == wc20) ||
;wc21="combobox"
(TheClass == wc21) ||
;wc22="listbox"
(TheClass == wc22)
) then
	let nsOnFormField = TRUE
	{tab}
	return
else
	let nsOnFormField = FALSE
	Let WinHandle = GetFirstChild (WinHandle)
EndIf
While (WinHandle)
	if Not (IsWindowObscured(WinHandle)) then
		let TheClass = GetWindowClass(WinHandle)
;wc19="edit"
		If ((TheClass == wc19) ||
;wc20="button"
		(TheClass == wc20) ||
;wc21="combobox"
		(TheClass == wc21) ||
;wc22="listbox"
		(TheClass == wc22)
		)then
			JawsCursor ()
			MoveToWindow (WinHandle)
			RouteInvisibleToJaws()
			SayPromptAndField () ; says field and prompt
			LeftMouseButton ()
;			SetFocus (WinHandle)
			PCCursor()
			return
		EndIf
	EndIf
	Let WinHandle = GetNextWindow (WinHandle)
EndWhile
if (Getverbosity() == BEGINNER) then
	if (nsOnFormField) then
		Say(msg23, OT_MESSAGE) ;"No more input fields on this screen"
	else
		Say(msg24, OT_MESSAGE) ;"no input fields on this screen"
	EndIf
else
	Beep ()
EndIf
EndScript

Script  MoveToPriorControl()
; moves backword to find edit fields and other controls on forms.
var
	handle WinHandle,
	string TheClass,
	int TheType,
	int nsOnFormField
Let WinHandle = GetFocus ()
let TheClass  = GetWindowClass(WinHandle) 
;wc19="edit"
If ((TheClass == wc19) ||
;wc20="button"
(TheClass == wc20) ||
;wc21="combobox"
(TheClass == wc21) ||
;wc22="listbox"
(TheClass == wc22)
) then
	let nsOnFormField = TRUE
	{shift tab}
	return
else
	let nsOnFormField = FALSE
	Let WinHandle = GetFirstChild (WinHandle)
EndIf
While (WinHandle)
	if Not (IsWindowObscured(WinHandle)) then
		let TheClass = GetWindowClass(WinHandle)
		;wc19="edit"
		If ((TheClass == wc19) ||
		;wc20="button"
		(TheClass == wc20) ||
		;wc21="combobox"
		(TheClass == wc21) ||
		;wc22="listbox"
		(TheClass == wc22)
		)then
			JawsCursor()
			MoveToWindow(WinHandle)
			RouteInvisibleToJaws()
			SayPromptAndField ()
			LeftMouseButton ()
;			setFocus (WinHandle)
			PCCursor()
			return
		EndIf
	EndIf
	Let WinHandle = GetPriorWindow (WinHandle)
EndWhile
if (Getverbosity() == BEGINNER) then
	if (nsOnFormField) then
		Say(msg23, OT_MESSAGE) ;"No more input fields on this screen"
	else
		Say(msg24, OT_MESSAGE) ;"no input fields on this screen"
	EndIf
else
	Beep ()
EndIf
EndScript

Function SayPromptAndField ()
; used to read control and prompt.
var
	int TheType,
	handle WinHandle
SaveCursor()
InvisibleCursor()
let WinHandle = GetCurrentWindow()
let TheType = GetWindowTypeCode(WinHandle)
if (TheType == WT_EDIT) then
;wn28=":"
	if (StringContains(GetLine(),wn28)) then
	; Prompt is on this line
		SayToCursor()
	else
		PriorLine()
		SayLine()
		Nextline()
	EndIf
EndIf
if ((TheType == WT_CHECKBOX) ||
(TheType == WT_RADIOBUTTON))
then
	NextWord()
	SayChunk()
EndIf
if (TheType == WT_COMBOBOX) then
	PriorWord()
	SayChunk()
EndIf
RestoreCursor()
EndFunction

Script ToggleStatusLineVerbosity()
; Toggles Status Line for automatic reading, this is off by default.
if nsSpeakStatusLine then
	let nsSpeakStatusLine = FALSE
	Say(msg25, OT_MESSAGE) ;"Status line off"
else
	let nsSpeakStatusLine = TRUE
	Say(msg26, OT_MESSAGE) ;"Status line on"
EndIf
EndScript

Script ForcePageDown()
; forces a page down, even in forms.
var
	handle WinHandle,
	STRING TheClass
if (MenusActive() || DialogActive()) then
	return
EndIf
let WinHandle = GetFocus()
let TheClass = GetWindowClass(WinHandle)
if (TheClass != wc_page) then
	SaveCursor ()
	JawsCursor ()
	MoveToControl (GetAppMainWindow (WinHandle), cid_page)
	LeftMouseButton ()
;	SetFocus(GetParent(WinHandle))
	RestoreCursor ()
	delay (1)
EndIf
{PageDown}
EndScript

Script ForcePageUp()
; forces a page up, even in forms.
var
	handle WinHandle,
	STRING TheClass
if (MenusActive() || DialogActive()) then
	return
EndIf
let WinHandle = GetFocus()
let TheClass = GetWindowClass(WinHandle)
if (TheClass != wc_page) then
	SaveCursor ()
	JawsCursor ()
	MoveToControl (GetAppMainWindow (WinHandle), cid_page)
	LeftMouseButton ()
;	SetFocus(GetParent(WinHandle))
	delay (1)
	RestoreCursor ()
EndIf
{PageUp}
EndScript

Script SayLine()
; If we're in a Netscape form and the PC cursor is on, try to say the
; field along with its prompt
var 
	handle WinHandle
if (IsPCCursor()) then
	if not (MenusActive() || DialogActive()) then
		let WinHandle = GetCurrentWindow()
		if ((GetWindowTypeCode(WinHandle) != WT_UNKNOWN) &&
		(GetWindowClass (GetParent (WinHandle)) == wc_page)) then
			InvisibleCursor ()
			MoveToWindow (WinHandle)
			SayPromptAndField ()
			PCCursor ()
		EndIf
	EndIf
EndIf
SayLine()
EndScript

Script MoveToAddressBar()
; focuses the location edit field by clicking on it
;wn62="Open Location"
If (GetWindowName (GetRealWindow (GetFocus ())) == wn62) then
	Say(msg63, OT_STRING) ;"Open Location edit"
	Return
EndIf
JawsCursor ()
;fs30="Location:"
If (FindString (GetFocus (), fs30, s_top, s_unrestricted) ||
;fs31="Go to:"
FindString (GetFocus (), fs31, s_top, s_unrestricted) ||
;fs32="Netsite:"
FindString (GetFocus (), fs32, s_top, s_unrestricted)) then
	NextWord ()
	While (GetWindowTypeCode (GetCurrentWindow ()) != wt_edit)
		NextWord ()
	EndWhile
	SayToCursor ()
	PCCursor ()
	RoutePcToJaws ()
Else
	Say(msg65, OT_MESSAGE) ;"location bar not found"
EndIf  
EndScript

Script  ReadBodyPage()
; Have the Invisible cursor read the body of text.
; mod by J Dunn 19/1/98
SaveCursor()
JawsCursor ()
MoveToControl (GetAppMainWindow (GetFocus ()), cid_page)
RouteInvisibleToJaws()
InvisibleCursor()
SayAll ()
restoreCursor()
EndScript

Script ReadColumnDown()
; used to assist in reading columns when the JAWS cursor is active.
NextLine ()
SayChunk ()
EndScript

Script  ReadColumnUp()
; used to assist in reading columns when the JAWS cursor is active.
PriorLine ()
SayChunk ()
EndScript

Script  ReadColumnLeft()
; used to assist in reading columns when the JAWS cursor is active.
PriorChunk ()
;wn72="]"
While (GetCharacter() == wn14) || (GetCharacter() ==wn72) 
	PriorChunk ()
EndWhile
SayField ()
EndScript

Script ReadColumnRight()
; used to assist in reading columns when the JAWS cursor is active.
NextChunk ()
;wn72="]"
While (GetCharacter() == wn14) || (GetCharacter() ==wn72) 
	NextChunk ()			
EndWhile
SayField ()
EndScript

Script  ReturnToPageBody()
; focuses the page window by clicking the cursor on it
JawsCursor ()
MoveToControl (GetAppMainWindow (GetFocus ()), cid_page)
LeftMouseButton ()
PCCursor ()
EndScript

Script HotKeyHelp()
var
	handle WinHandle,
	string TheClass,
	string Address
let WinHandle = GetCurrentWindow ()
let TheClass = GetWindowClass (WinHandle)
if (TheClass == wc_page) then

SaveCursor ()
InvisibleCursor ()
;fs30="Location:"
If (FindString (GetFocus (), fs30, s_top, s_unrestricted) ||
;fs31="Go to:"
FindString (GetFocus (), fs31, s_top, s_unrestricted) ||
;fs32="Netsite:"
FindString (GetFocus (), fs32, s_top, s_unrestricted)) then
	NextWord ()
	While (GetWindowTypeCode (GetCurrentWindow ()) != wt_edit)
		NextWord ()
	EndWhile
	Let Address = GetChunk () 
;wn33="ftp.hj.com"
	If StringContains (Address, wn33) then
		Say(msg40, OT_HELP) ;"You are currently located on the henter-joyce ftp site"
		Say(msg34 + msg35, OT_HELP) ; "In order to download files from this site, place your jaws cursor on the desired file and double click",
		Say(msg41, OT_HELP) ;"then turn on your pc cursor to navigate the download dialog box"
		If (GetVerbosity () == 0) then
			Say(msg36 + msg37, OT_HELP) ; "You can either double click by pressing the left mouse button twice quickly or by pressing jaws left mouse button twice quickly",
		EndIf
		Say(msg38 + msg39, OT_HELP) ; "In order to download files that are not visibly listed, include the file name in your location address when logging onto the site",
	EndIf
EndIf
restoreCursor ()
say(msg123, OT_HELP) ; use
Say(GetScriptKeyName("ReadBodyPage"), OT_HELP)
Say(msg127, OT_HELP) ; to reread the visible page.
Say(msg42 + msg43, OT_HELP) ; use tab and shift + tab etc 
Say(msg123, OT_HELP) ; use
Say(GetScriptKeyName("ToggleLinkSearchMethod"), OT_HELP)
Say(msg126, OT_HELP) ; to toggle between link search methods
say(msg123, OT_HELP) ;use
Say(GetScriptKeyName("SayCurrentLink"), OT_HELP)
say(msg132, OT_HELP) ; to repeat the last link spoken
Say(msg123, OT_HELP) ;use
Say(GetScriptKeyName("ToolbarDialog"), OT_HELP)
say(msg124, OT_HELP) ; to select a toolbar button from a list
Say(msg123, OT_HELP) ; use
Say(GetScriptKeyName("ToggleStatusLineVerbosity"), OT_HELP) 
Say(msg134, OT_HELP) ; to toggle status line verbosity

say(msg123, OT_HELP) ; use
say(GetScriptKeyName("findNextGraphic"), OT_HELP)
say(msg129, OT_HELP) ; and
Say(GetScriptKeyName("findPriorGraphic"), OT_HELP) 
Say(msg130, OT_HELP) ; to locate next or prior graphic
Say(msg46 + msg47, OT_HELP) ; "When the jaws cursor is active, home and end moves respectively to the beginning and end of the line",
Say(msg48 + msg49, OT_HELP) ; "When the Pc cursor is active, home and end moves respectively to the first and last hyper link text",
Say(msg56, OT_HELP) ;"To find and place the pc cursor in an edit box, use")
Say(GetScriptKeyName("moveToNextControl"), OT_HELP)
Say(msg57, OT_HELP) ; also use this to move through controls on a form 
Say(msg58, OT_HELP) ;"When you are filling in forms"
Say(msg59, OT_HELP) ;"use control with page up and down to change pages"
say(msg123, OT_HELP) ; use
say(GetScriptKeyName("moveToAddressBar"), OT_HELP) 
say(msg131, OT_HELP) ; to move to the address bar.
say(msg123, OT_HELP) ; use
Say(GetScriptKeyName("returnToPageBody"), OT_HELP) ;
say(msg133, OT_HELP) ; to return to the page 
SayExtendedHelpHotKey ()
return

EndIf
HotKeyHelpDefaultLoop ()  ; standard dialog boxes
EndScript

Script ScreenSensitiveHelp()
var
int TheTypeCode,
String TheClass
if (IsSameScript ()) then
	AppFileTopic()
	return
EndIf
Let TheClass = GetWindowClass (GetCurrentWindow ())
let TheTypeCode = GetWindowTypeCode (GetCurrentWindow())
if (GlobalMenuMode == 1) then
	ScreenSensitiveHelpForKnownClasses()  ;known types
	return
endif
if (TheClass == wc_page) then
	Say(msg135, OT_HELP) ; "this is the main Netscape Navigator window "
	Say(msg136, OT_HELP) ; "in which you can read the current loaded page "
	Say(msg137, OT_HELP) ; "or select a link to go to another site "
	return
EndIf
if (TheTypeCode < 1) then
	if (TheTypeCode == WT_UNKNOWN) then
		  Say(msg138, OT_HELP) ; "This is a custom window type"
	endif
	ScreenSensitiveHelpForUnknownClasses()  ; handle unknown window types and classes
else
	ScreenSensitiveHelpForKnownClasses()  ;known types
EndIf
EndScript

Int Function InNavigator ()
var
string WinTitle
let WinTitle = GetWindowName(GetRealWindow(GetCurrentWindow()))

if StringContains(WinTitle, "Composer") then
return 0
elif StringContains(WinTitle, "Composition") then
return 0
elif StringContains(winTitle, "Message") then
return 0
else
return 1
endif
EndFunction
Script  SayCharacter()
if IsPCCursor() then
	if (GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
		SayWord() ; says the current setting
		return
	endif
endif
if (IsSameScript ()) then
;  SpeakTheChanges(FALSE)
	SayCharacterPhonetic ()
	AddHook (HK_SCRIPT, "PhoneticSpellHook")
else
;  SpeakTheChanges(false)
	let globalSayingCurrentItem = 1
	SayCharacter()
	let globalSayingCurrentItem = 0
EndIf
EndScript
string Function AltText ()
var
string TheText,
int col,
int row,
int safety

SaveCursor()
RouteInvisibleToJaws()
InvisibleCursor()
let row=GetLineTop()
nextWord()
let col = GetCursorCol()
let safety=0
while (row==GetLineTop()) && not (getCharacterAttributes() & attrib_graphic) && safety < 1000
  let TheText=TheText+" "+GetWord()
  NextWord()
  let safety = safety +1
EndWhile
RestoreCursor()
return TheText
EndFunction


string Function GetGraphicName ()
var
int verbosity,
int ScreenEcho,
string name


let Name=GetWord()
SaveCursor()
let ScreenEcho=GetJcfOption(opt_screen_echo)
let verbosity=getVerbosity()
while GetVerbosity()!=2 
VerbosityLevel()
endWhile
setJcfOption(opt_screen_echo, 0) ; turn it off temporarily
RightMouseButton()
pause()
if FindString(GetFocus(), "view image", s_top, s_restricted) then
 NextWord()
nextWord()
let Name=GetWord()
NextWord()
let name=name+GetWord()
endIf
{escape}
pause()
pause()
while GetVerbosity()!=Verbosity 
VerbosityLevel ()
EndWhile
SetJcfOption(opt_screen_echo, screenEcho)
RestoreCursor()
pause()
if StringContains(LastStatusMsg,"//") && (not Stringcontains(name, "Scroll ")) then
return "link: "+name+AltText()
else
return name+AltText()
endIf
EndFunction

Script SayWord()

if GetCharacterAttributes() ==attrib_graphic then
if IsSameScript() then
  SpellString(GraphicName)
else
let GraphicName = GetGraphicName()
Say(GraphicName, OT_GRAPHIC)
BrailleString(GraphicName)
endif
return
endif

If (IsSameScript ()) Then
	SpellWord()
	AddHook (HK_SCRIPT, "SpellWordHook")
Else
	let globalSayingCurrentItem = 1
	SayWord()
	let globalSayingCurrentItem = 0
EndIf
EndScript


Script FindNextGraphic ()
if not NextGraphicFound then ; start searching from top of visible page
	MoveToControl (GetAppMainWindow (GetFocus ()), cid_page)
endIf
if findNextAttribute (attrib_graphic) && GetCurrentControlID ()==cid_page then
let GraphicName=GetGraphicName()
Say(GraphicName, OT_GRAPHIC)
BrailleString(GraphicName)
let NextGraphicFound=true
else
if NextGraphicFound==true then
PcCursor()
Say(msg113a, OT_MESSAGE) ; last graphic
Say(GraphicName, OT_GRAPHIC)
BrailleString(GraphicName)
else
PcCursor()
Say(msg114, OT_MESSAGE) ; no graphics found
endif
Endif
EndScript

Script FindPriorGraphic ()
if not PriorGraphicFound then ; start searching from bottom of visible page
	MoveToControl (GetAppMainWindow (GetFocus ()), cid_page)
JawsPageDown()
PriorLine()
JawsEnd()
endIf

if findPriorAttribute (attrib_graphic) && GetCurrentControlID ()==cid_page then
let GraphicName=GetGraphicName()
Say(GraphicName, OT_GRAPHIC)
BrailleString(GraphicName)
let PriorGraphicFound=true
else
if PriorGraphicFound then
PcCursor()
Say(msg113, OT_GRAPHIC) ; first graphic
Say(GraphicName, OT_GRAPHIC)
BrailleString(GraphicName)
else
PcCursor()
Say(msg114, OT_MESSAGE) ; no graphics found
endif
endif
EndScript


Script Back ()
if InNSNavigator then
if IsJawsCursor() then
  PcCursor()
EndIf
if GetVerbosity()==beginner then
Say(msg117, OT_MESSAGE)
endIf
{alt+left arrow}
endIf
EndScript


Script forward ()
if InNSNavigator then
if IsJawsCursor() then
  PcCursor()
EndIf
if GetVerbosity()==beginner then
Say(msg118, OT_MESSAGE)
endIf
{alt+right arrow}
endIf
EndScript


Script SayStatusBarMsg ()
let SuppressEcho=true
pause()
let suppressEcho=false
Say(LastStatusMsg, OT_MESSAGE)
EndScript


Script PageUp ()
Say(msg27, OT_MESSAGE)
if GetCurrentControlID()==cid_page && IsJAWSCursor() then
  MoveToControl (GetAppMainWindow (GetFocus ()), cid_page)
else
  {pageup}
endIf
EndScript


Script pagedown ()
Say(msg28, OT_MESSAGE)
if GetCurrentControlID()==cid_page && IsJAWSCursor() then
  MoveToControl (GetAppMainWindow (GetFocus ()), cid_page)
  JawsPageDown()
  PriorLine()
else
  {pagedown}
endIf
EndScript

Script SayPriorCharacter ()
var
	int TheTypeCode
PriorCharacter()
if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
if not IsPCCursor() then
;  SpeakTheChanges(TRUE)
	SayCharacter()
	return
endif
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL ||
    GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
	SayWord()
	return
endif
if CaretVisible() then
  	SayCharacter()
	Return
else
	let TheTypeCode = GetWindowSubTypeCode (GetCurrentWindow())
	If (TheTypeCode == WT_MENU) then
		Say(msg3, OT_MESSAGE) ;"Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
	if (TheTypeCode == WT_STARTMENU) then
		Say(msg4, OT_MESSAGE) ;"Start Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
	if (TheTypeCode == WT_CONTEXTMENU) then
		Say(msg5, OT_MESSAGE) ;"Context Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
endif
EndScript

Script SayNextCharacter () 
var
	int TheTypeCode
NextCharacter()
if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
if not IsPCCursor() then
;  SpeakTheChanges(TRUE)
	SayCharacter()
	return
endif
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL ||
    GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
	SayWord()
	return
endif
if CaretVisible() then
	SayCharacter()
	Return
else
	let TheTypeCode = GetWindowSubTypeCode (GetCurrentWindow())
	If (TheTypeCode == WT_MENU) then
		Say(msg3, OT_MESSAGE) ;"Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
	if (TheTypeCode == WT_STARTMENU) then
		Say(msg4, OT_MESSAGE) ;"Start Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
	if (TheTypeCode == WT_CONTEXTMENU) then
		Say(msg5, OT_MESSAGE) ;"Context Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
endif
EndScript

Script SayPriorLine () 
var
	int TheTypeCode
PriorLine()
if (IsLeftButtonDown ()) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
if not IsPCCursor () then
;  SpeakTheChanges(TRUE)
	SayLine()
	return
endif
if (GetWindowTypeCode (GetCurrentWindow ()) == WT_SLIDER) then
	SayWord ()
	return
EndIf
if (GetWindowTypeCode (GetCurrentWindow ()) == WT_TABCONTROL) then
	SayWord()
	return
EndIf
if CaretVisible() then
	SayLine()
	return
EndIf
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow ())
if ((TheTypeCode == WT_TREEVIEW) ||
	(TheTypeCode == WT_MULTISELECT_LISTBOX) ||
	(TheTypeCode == WT_EXTENDEDSELECT_LISTBOX)) then
	SayLine()
EndIf
EndScript

Script SayNextLine() 
var
	int TheTypeCode
NextLine()
if (IsLeftButtonDown ()) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
if  not IsPCCursor () then
;  SpeakTheChanges(TRUE)
	SayLine ()
	return
EndIf
if (GetWindowTypeCode (GetCurrentWindow ()) == WT_SLIDER) then
	SayWord ()
	return
EndIf
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL) then
	SayWord()
	return
EndIf
if CaretVisible () then
	SayLine ()
	return
EndIf
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow())
if ((TheTypeCode == WT_TREEVIEW) ||
   (TheTypeCode == WT_MULTISELECT_LISTBOX) ||
   (TheTypeCode == WT_EXTENDEDSELECT_LISTBOX)) then
	SayLine()
endif
EndScript

Script SayNextWord()
NextWord()
if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
;  SpeakTheChanges(TRUE)
SayWord()
EndScript

Script SayPriorWord() 
PriorWord()
if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
;  SpeakTheChanges(TRUE)
SayWord()
EndScript



void Function ActivateButton (string BtnName)
var 
int FoundAButton

SaveCursor()
JAWSCursor()
let foundAButton=0
pause()
if btnName==btn3 then ; must look for two different buttons
  if FindGraphic (GetAppMainWindow(GetCurrentWindow()), btn3a, s_top, s_unrestricted) then
    let foundAButton=1
  elif FindGraphic (GetAppMainWindow(GetCurrentWindow()), btn3b, s_top, s_unrestricted) then
    let FoundAButton=1
  endIf
elif FindGraphic(GetAppMainWindow(GetCurrentWindow()), btnName, s_top, s_unrestricted) then
  let FoundAButton=1
endIf
if FoundAButton then
  SayWord()
  LeftMouseButton()
else ; button not found
  restoreCursor()
  Say(btnName, OT_MESSAGE)
  Say(msg122, OT_MESSAGE) ; not found
EndIf
EndFunction

Script ToolbarDialog ()
var
string btnList,
int index

let btnList=btn1+"|"+btn2+"|"+btn3+"|"+btn4+"|"+btn5+"|"+btn6+"|"+btn7+"|"+btn8+"|"
let index=DlgSelectItemInList (btnList, "Select a Toolbar Button", false)
let suppressEcho=1
if index==1 then
  ActivateButton(btn1)
elif index==2 then
  activateButton(btn2)
elif index==3 then
  activateButton(btn3)
elif index==4 then
  activateButton(btn4)
elif index==5 then
  activateButton(btn5)
elif index==6 then
  activateButton(btn6)
elif index==7 then
  activateButton(btn7)
elif index==8 then
  activateButton(btn8)
endIf 
let suppressEcho=false
EndScript



Script ToggleLinkSearchMethod ()
SaveCursor()
pcCursor()
if LinkSearchMethod==0 then
  Say(msg121, OT_MESSAGE) ; focus rect
  let linkSearchMethod=1
else
  Say(msg120, OT_MESSAGE) ; underlined method
  let linkSearchMethod=0
EndIf
Restorecursor()
EndScript